<?php $__env->startSection('content'); ?>
<div class="row justify-content-center">
    <div class="col-md-10">
        <div class="card">
            <div class="card-header">
                <h2>Tambah Pelanggan Baru</h2>
            </div>
            <div class="card-body">
                <form action="<?php echo e(route('pelanggan.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    
                    <div class="card mb-3">
                        <div class="card-header">Data Diri</div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="nama_pelanggan" class="form-label">Nama Pelanggan</label>
                                    <input type="text" class="form-control" id="nama_pelanggan" name="nama_pelanggan" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="tanggal" class="form-label">Tanggal</label>
                                    <input type="date" class="form-control" id="tanggal" name="tanggal" value="<?php echo e(date('Y-m-d')); ?>" required>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label for="alamat" class="form-label">Alamat</label>
                                <textarea class="form-control" id="alamat" name="alamat" rows="3" required></textarea>
                            </div>
                            <div class="mb-3">
                                <label for="no_telepon" class="form-label">No Telepon</label>
                                <input type="text" class="form-control" id="no_telepon" name="no_telepon" required>
                            </div>
                        </div>
                    </div>

                    
                    <div class="card mb-3">
                        <div class="card-header">Resep Kacamata</div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <h5>Mata Kanan (OD)</h5>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text">SPH</span>
                                        <input type="text" class="form-control" name="sph_r">
                                    </div>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text">CYL</span>
                                        <input type="text" class="form-control" name="cyl_r">
                                    </div>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text">AXIS</span>
                                        <input type="text" class="form-control" name="axis_r">
                                    </div>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text">ADD</span>
                                        <input type="text" class="form-control" name="add_r">
                                    </div>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text">PDD</span>
                                        <input type="text" class="form-control" name="pdd_r">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <h5>Mata Kiri (OS)</h5>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text">SPH</span>
                                        <input type="text" class="form-control" name="sph_l">
                                    </div>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text">CYL</span>
                                        <input type="text" class="form-control" name="cyl_l">
                                    </div>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text">AXIS</span>
                                        <input type="text" class="form-control" name="axis_l">
                                    </div>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text">ADD</span>
                                        <input type="text" class="form-control" name="add_l">
                                    </div>
                                    <div class="input-group mb-2">
                                        <span class="input-group-text">PDD</span>
                                        <input type="text" class="form-control" name="pdd_l">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    
                    <div class="card mb-3">
                        <div class="card-header">Frame & Pembayaran</div>
                        <div class="card-body">
                             <div class="mb-3">
                                <label for="merk_frame" class="form-label">Merk Frame</label>
                                <input type="text" class="form-control" id="merk_frame" name="merk_frame" required>
                            </div>
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <label for="total_bayar" class="form-label">Total Bayar</label>
                                    <input type="number" class="form-control" id="total_bayar" name="total_bayar" value="0" required>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="dp" class="form-label">DP</label>
                                    <input type="number" class="form-control" id="dp" name="dp" value="0" required>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label for="sisa_pembayaran" class="form-label">Sisa Pembayaran</label>
                                    <input type="number" class="form-control" id="sisa_pembayaran" name="sisa_pembayaran" value="0" readonly>
                                </div>
                            </div>
                             <div class="mb-3">
                                <label for="tanggal_kirim" class="form-label">Tanggal Kirim ke Konsumen</label>
                                <input type="date" class="form-control" id="tanggal_kirim" name="tanggal_kirim">
                            </div>
                        </div>
                    </div>

                    <div class="d-grid">
                        <button type="submit" class="btn btn-primary">Simpan Data</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
    // Script to calculate sisa pembayaran automatically
    const totalBayar = document.getElementById('total_bayar');
    const dp = document.getElementById('dp');
    const sisaPembayaran = document.getElementById('sisa_pembayaran');

    function calculateSisa() {
        const total = parseFloat(totalBayar.value) || 0;
        const downPayment = parseFloat(dp.value) || 0;
        const sisa = total - downPayment;
        sisaPembayaran.value = sisa;
    }

    totalBayar.addEventListener('input', calculateSisa);
    dp.addEventListener('input', calculateSisa);
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\laragon\www\optic\resources\views/pelanggan/create.blade.php ENDPATH**/ ?>