@extends('layouts.app')

@section('content')
<div class="row justify-content-center">
    <div class="col-md-10">
        <div class="card">
            <div class="card-header">
                <div class="d-flex justify-content-between align-items-center">
                    <h2 class="mb-0">Detail Pelanggan</h2>
                    <a href="{{ route('pelanggan.index') }}" class="btn btn-secondary">Kembali</a>
                </div>
            </div>
            <div class="card-body">
                {{-- Data Diri --}}
                <div class="card mb-3">
                    <div class="card-header">Data Diri</div>
                    <div class="card-body">
                        <dl class="row">
                            <dt class="col-sm-3">Nama</dt>
                            <dd class="col-sm-9">{{ $pelanggan->nama_pelanggan }}</dd>

                            <dt class="col-sm-3">Tanggal Order</dt>
                            <dd class="col-sm-9">{{ \Carbon\Carbon::parse($pelanggan->tanggal)->format('d F Y') }}</dd>

                            <dt class="col-sm-3">Alamat</dt>
                            <dd class="col-sm-9">{{ $pelanggan->alamat }}</dd>

                            <dt class="col-sm-3">No. Telepon</dt>
                            <dd class="col-sm-9">{{ $pelanggan->no_telepon }}</dd>
                        </dl>
                    </div>
                </div>

                {{-- Resep --}}
                <div class="card mb-3">
                    <div class="card-header">Resep Kacamata</div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h5>Mata Kanan (OD)</h5>
                                <dl class="row">
                                    <dt class="col-sm-3">SPH</dt><dd class="col-sm-9">{{ $pelanggan->sph_r ?? '-' }}</dd>
                                    <dt class="col-sm-3">CYL</dt><dd class="col-sm-9">{{ $pelanggan->cyl_r ?? '-' }}</dd>
                                    <dt class="col-sm-3">AXIS</dt><dd class="col-sm-9">{{ $pelanggan->axis_r ?? '-' }}</dd>
                                    <dt class="col-sm-3">ADD</dt><dd class="col-sm-9">{{ $pelanggan->add_r ?? '-' }}</dd>
                                    <dt class="col-sm-3">PDD</dt><dd class="col-sm-9">{{ $pelanggan->pdd_r ?? '-' }}</dd>
                                </dl>
                            </div>
                            <div class="col-md-6">
                                <h5>Mata Kiri (OS)</h5>
                                <dl class="row">
                                    <dt class="col-sm-3">SPH</dt><dd class="col-sm-9">{{ $pelanggan->sph_l ?? '-' }}</dd>
                                    <dt class="col-sm-3">CYL</dt><dd class="col-sm-9">{{ $pelanggan->cyl_l ?? '-' }}</dd>
                                    <dt class="col-sm-3">AXIS</dt><dd class="col-sm-9">{{ $pelanggan->axis_l ?? '-' }}</dd>
                                    <dt class="col-sm-3">ADD</dt><dd class="col-sm-9">{{ $pelanggan->add_l ?? '-' }}</dd>
                                    <dt class="col-sm-3">PDD</dt><dd class="col-sm-9">{{ $pelanggan->pdd_l ?? '-' }}</dd>
                                </dl>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Pembayaran --}}
                <div class="card">
                    <div class="card-header">Frame & Pembayaran</div>
                    <div class="card-body">
                        <dl class="row">
                            <dt class="col-sm-3">Merk Frame</dt>
                            <dd class="col-sm-9">{{ $pelanggan->merk_frame }}</dd>

                            <dt class="col-sm-3">Total Bayar</dt>
                            <dd class="col-sm-9">Rp {{ number_format($pelanggan->total_bayar, 0, ',', '.') }}</dd>

                            <dt class="col-sm-3">DP</dt>
                            <dd class="col-sm-9">Rp {{ number_format($pelanggan->dp, 0, ',', '.') }}</dd>

                            <dt class="col-sm-3">Sisa Pembayaran</dt>
                            <dd class="col-sm-9">Rp {{ number_format($pelanggan->sisa_pembayaran, 0, ',', '.') }}</dd>

                            <dt class="col-sm-3">Tanggal Kirim</dt>
                            <dd class="col-sm-9">{{ $pelanggan->tanggal_kirim ? \Carbon\Carbon::parse($pelanggan->tanggal_kirim)->format('d F Y') : 'Belum ditentukan' }}</dd>
                        </dl>
                    </div>
                </div>

            </div>
            <div class="card-footer text-end">
                <a href="{{ route('pelanggan.edit', $pelanggan->id) }}" class="btn btn-primary">Edit</a>
            </div>
        </div>
    </div>
</div>
@endsection
