@extends('layouts.app')

@section('content')
    @if ($message = Session::get('success'))
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            {{ $message }}
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    @endif
    <div class="card mb-4">
        <div class="card-header">Filter Data</div>
        <div class="card-body">
            <form action="{{ route('pelanggan.index') }}" method="GET" class="row g-3 align-items-end">
                <div class="col-md-4">
                    <label for="search" class="form-label">Nama Pelanggan</label>
                    <input type="text" name="search" id="search" class="form-control" placeholder="Cari Nama..." value="{{ request('search') }}">
                </div>
                <div class="col-md-3">
                    <label for="start_date" class="form-label">Dari Tanggal</label>
                    <input type="date" name="start_date" id="start_date" class="form-control" value="{{ request('start_date') }}">
                </div>
                <div class="col-md-3">
                    <label for="end_date" class="form-label">Sampai Tanggal</label>
                    <input type="date" name="end_date" id="end_date" class="form-control" value="{{ request('end_date') }}">
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-primary">Filter</button>
                    <a href="{{ route('pelanggan.index') }}" class="btn btn-secondary ms-1">Reset</a>
                </div>
            </form>
        </div>
    </div>

    <div class="card">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <h2 class="mb-0">Data Pelanggan</h2>
                <a href="{{ route('pelanggan.create') }}" class="btn btn-primary">Tambah Pelanggan</a>
            </div>
            @isset($totalPendapatan)
            <div class="mt-3 p-3 bg-light rounded">
                <h5>Total Pendapatan (Berdasarkan Filter): <span class="text-success fw-bold">Rp {{ number_format($totalPendapatan, 0, ',', '.') }}</span></h5>
            </div>
            @endisset
        </div>
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>#</th>
                            <th>Tanggal</th>
                            <th>Nama</th>
                            <th>Alamat</th>
                            <th>No. Telepon</th>
                            <th>Total Bayar</th>
                            <th>Sisa</th>
                            <th>Tgl. Kirim</th>
                            <th>Aksi</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($pelanggans as $pelanggan)
                            <tr>
                                <td>{{ $loop->iteration + $pelanggans->firstItem() - 1 }}</td>
                                <td>{{ \Carbon\Carbon::parse($pelanggan->tanggal)->format('d-m-Y') }}</td>
                                <td>{{ $pelanggan->nama_pelanggan }}</td>
                                <td>{{ $pelanggan->alamat }}</td>
                                <td>{{ $pelanggan->no_telepon }}</td>
                                <td>Rp {{ number_format($pelanggan->total_bayar, 0, ',', '.') }}</td>
                                <td>Rp {{ number_format($pelanggan->sisa_pembayaran, 0, ',', '.') }}</td>
                                <td>{{ $pelanggan->tanggal_kirim ? \Carbon\Carbon::parse($pelanggan->tanggal_kirim)->format('d-m-Y') : '-' }}</td>
                                <td>
                                    <form action="{{ route('pelanggan.destroy', $pelanggan->id) }}" method="POST" class="btn-group" role="group">
                                        <a href="{{ route('pelanggan.show', $pelanggan->id) }}" class="btn btn-info btn-sm">Detail</a>
                                        <a href="{{ route('pelanggan.edit', $pelanggan->id) }}" class="btn btn-primary btn-sm">Edit</a>
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Apakah Anda yakin ingin menghapus data ini?')">Hapus</button>
                                    </form>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="9" class="text-center">Belum ada data.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div class="d-flex justify-content-center">
                {{ $pelanggans->links() }}
            </div>

        </div>
    </div>
@endsection
